#!/bin/bash
#
#   This script is used to update MC/SC firmware 
#			October 17, 2018
#                       matsuzawa.jei@nifty.com

GetYesNo() {
_ANSWER=
while :
do
    echo -n "$@"
    read _ANSWER
    case "$_ANSWER" in
        [yY] | yes | YES | Yes) return 1 ;;
        [nN] | no | NO | No) return 0 ;;
        *) echo "Please enter y or n." ;;
    esac
done
}

if [ $# -ne 1 ]; then 
    echo -e "U sage:\\tmcupdator.sh {fname}"
    echo -e "\\tfname = file name of firmware"
    exit 1
fi

FNAME=$1
CPU=${FNAME:1:2}
MVER1=${FNAME:3:1}
MVER2=${FNAME:4:1}
VER=${FNAME:5:2}
VERSION="${MVER1}.${MVER2}-${VER}"
ARG="${FNAME}.MOT"

case "$CPU" in
    M1)    echo "MC CPU1 ${VERSION}" ;;
    M2)    echo "MC CPU2 ${VERSION}" ;;
    SC)    echo "SC ${VERSION}" ;;
esac

# check firmware 
if GetYesNo "Is firmware version correct (y/n)? "; then
    exit 1 
fi

# check serial cable
if GetYesNo "Is the serial cable connected (y/n)? "; then
    exit 1 
fi

# check BOOT mode 
if GetYesNo "Is it in BOOT mode (y/n)? "; then
    exit 1 
fi

# final confirmation  
if GetYesNo "Are you ready (y/n)? "; then
    exit 1 
fi
sudo /usr/local/bin/mcUpdator ${ARG}

