#include	<iostream>
#include	<fstream>
#include	<sys/ioctl.h>
#include	<unistd.h>
#include    <stdio.h>
using namespace std;

#include	"../include/pifg/libPIF.h"
#include	"../include/pifg/CLog.h"
#include <sys/stat.h>

// added valid checksum values
#define LAST_CHECKSUM   0xde                          // checksum 222 = 0xde
#define LAST_CHECKSUM2 (LAST_CHECKSUM ^ 0x73)       // checksum 173 = 0xad
#define LAST_CHECKSUM3 (LAST_CHECKSUM ^ 0xb3)       // checksum 109 = 0x6d
#define LAST_CHECKSUM4 (LAST_CHECKSUM ^ 0xaa)       // checksum 116 = 0x74
//#define LAST_CHECKSUM5 (LAST_CHECKSUM ^ 0xad)     // checksum 115 = 0x73
//#define LAST_CHECKSUM6 (LAST_CHECKSUM ^ 0x43)     // checksum 157 = 0x9d

// added isd filename
#define ISDFILE "/home/Genesis/bitmaps/1830/isd202/isd.img"
CLog	oLog;
int motherBoardVersion;
int printdataOn;

int	main(int argc, char* argv[])
{
	CPif*	plib;
// hold checksum value
	int checkSum;
	char tempString[200];
    string lineFromFile;
//  create CPif class instance
    if((plib = new CPif()) == NULL)
	{
		cout << "Faild to create CPif class instance!\n";
        return(false);
    }
    
     ifstream mbVersion("/home/Genesis/motherBoardVersion.txt");
        if(mbVersion.is_open()){
       //     while(!mbVersion.eof()){
            getline(mbVersion,lineFromFile); 
            motherBoardVersion = atoi(lineFromFile.c_str());
        }
// check checksum value
    for (int i = 0; i < 3; i++)
    {
        printf("Attempt: %d\n", i);
        checkSum = plib->p_getChecksum(0);
        cout << "calculated checksum is " << checkSum << endl;
        cout << "checksum1 " << LAST_CHECKSUM <<endl;
        cout << "checksum2 " << LAST_CHECKSUM2 <<endl;
        cout << "checksum3 " << LAST_CHECKSUM3 <<endl;
        cout << "checksum4 " << LAST_CHECKSUM4 <<endl;
        
        struct  stat fileInfo;
        stat("/home/Genesis/checkSumLog.txt",&fileInfo);
        if (fileInfo.st_size > 500000) 
            system("rm /home/Genesis/checkSumLog.txt");

        FILE * fPtr = fopen("/home/Genesis/checkSumLog.txt","a");
        if (i == 0){
            system("date >> /home/Genesis/checkSumLog.txt");
            if(motherBoardVersion == 1)
                fprintf (fPtr,"Mother Board Version = %d(Old_GigaByte)", motherBoardVersion);
            else if(motherBoardVersion == 2)
                fprintf (fPtr,"Mother Board Version = %d(New_JetWay)", motherBoardVersion);
            fprintf (fPtr,"\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        if(fPtr) {
            fprintf (fPtr,"\nAttempt: %d\n", i);
            fprintf (fPtr,"CheckSum value = %d or %x\n\n", checkSum,checkSum);
            fclose(fPtr);
        }    
        //if (checkSum > 0x0F)
        if (checkSum == LAST_CHECKSUM2 || checkSum == LAST_CHECKSUM3 || checkSum == LAST_CHECKSUM4)
            break;
    }
    
    if (checkSum == 0x74) // added @7.04-12 for the ISD TDU Screen version(JEI firmware version)
		strcpy (plib->pPanel->TDU_Graphic_Ver," = 1.0.2");
	cout << "ISD Firmware Version" << plib->pPanel->TDU_Graphic_Ver << endl;
	sprintf(tempString,"echo TDU Screen Data Version %s > /home/Genesis/TDU_Screen_Version.txt",plib->pPanel->TDU_Graphic_Ver);
	system (tempString);
	
    sleep(1);
	plib->p_clearScreen();
    sleep(1);
	plib->p_display(10,10,"BEGIN PANEL FLASH ROUTINE");
	sleep(1);
	plib->p_display(10,30,"CALCULATING CHECKSUM VALUE");
	sleep(1);

// flash if requested through TDU
	if(access("/home/Genesis/SLflashPanel",F_OK) == 0)
	{
		system("rm /home/Genesis/SLflashPanel");
		plib->p_display(10,50,"CHECKSUM VALID");
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH REQUESTED");
		cout << "flashISD" << "Start flashing!\n";
		plib->p_updateFlash((char*)ISDFILE,1);
		cout << "Complete successfully!\n";
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH COMPLETE");
	}
	
// no flash needed or requested
	else if(/*checkSum == LAST_CHECKSUM || */checkSum == LAST_CHECKSUM2 || checkSum == LAST_CHECKSUM3 || checkSum == LAST_CHECKSUM4)
	{
		// no need to update
		plib->p_display(10,50,"CHECKSUM IS VALID");
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH NOT NEEDED");
		sleep(1);
	}
// flash needed
	else
	{
		plib->p_display(10,50,"CHECKSUM INVALID");
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH NEEDED");
		cout << "flashISD" << "Start flashing!\n";
		plib->p_updateFlash((char*)ISDFILE,1);
		cout << "Complete successfully!\n";
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH COMPLETE");
	}
	return 0;
}
