////////////////////////////////////////////////////////////////////////////////
//	Module			: CLog.C
//	Description		: This is a class to wrap syslog. 
//
//	Compiler		: gcc 4.4.7++
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu.jei@nifty.com
//------------------------------------------------------------------------------
//	Maintenance:
//		Feb.12,'14	Renewal for CentOS6.5/64bit
////////////////////////////////////////////////////////////////////////////////
#include <iostream>
#include <sstream>
using namespace std;
#include	"../include/pifg/CLog.h"

void
CLog::log(const char* id, enum LogPriority level, std::string str)
{
//	setlogmask (LOG_UPTO (LOG_NOTICE)); 
	openlog (id, LOG_CONS | LOG_NDELAY, LOG_LOCAL1); 
	syslog(level, str.c_str()); 
	closelog (); 
}

void
CLog::log(const char* id, enum LogPriority level, const char* str)
{
//	setlogmask (LOG_UPTO (LOG_NOTICE)); 
	openlog (id, LOG_CONS | LOG_NDELAY, LOG_LOCAL1); 
	syslog(level, str); 
	closelog (); 
}
