/*
 	This file is part of Jenux.

    Jenux is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jenux is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jenux.  If not, see <http://www.gnu.org/licenses/>.

	Module			: CLog.C
	Description     : This is a class to wrap syslog. 
	Compiler		: gcc 4.8.5++
	Email			: matsuzawa.jei@nifty.com
	Maintenance		:
		Jul.13, '17	Released as GPL software officially
*/
#include <iostream>
#include <sstream>
using namespace std;
#include	"../../../include/pifg/CLog.h"

void
CLog::log(const char* id, enum LogPriority level, std::string str)
{
//	setlogmask (LOG_UPTO (LOG_NOTICE)); 
	openlog (id, LOG_CONS | LOG_NDELAY, LOG_LOCAL1); 
	syslog(level, "%s", str.c_str()); 
	closelog (); 
}

void
CLog::log(const char* id, enum LogPriority level, const char* str)
{
//	setlogmask (LOG_UPTO (LOG_NOTICE)); 
	openlog (id, LOG_CONS | LOG_NDELAY, LOG_LOCAL1); 
	syslog(level, "%s", str); 
	closelog (); 
}
