///////////////////////////////////////////////////////////////////////////////
//	Module		: CCom.h		
//	Description	: Header of CCom class 
//
//	Author		: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail		: matsuzawa.jei@nifty.com
//-----------------------------------------------------------------------------
//Maintenance:
//	Oct. 17, '18	1st release
////////////////////////////////////////////////////////////////////////////////
#ifndef SERIAL_INCLUDED 
#define SERIAL_INCLUDED       

#include	<termios.h>

//	baud rate
#define BAUD_3    		0	//BAUD RATE 300
#define BAUD_12   		1	//BAUD RATE 1200
#define BAUD_24   		2	//BAUD RATE 2400
#define BAUD_48   		3	//BAUD RATE 4800
#define BAUD_96   		4	//BAUD RATE 9600
#define BAUD_192  		5	//BAUD RATE 19200
#define BAUD_384  		6	//BAUD RATE 38400

//databits
#define BITS_7     		0	//word length 7
#define BITS_8     		1	//word length 8

//stopbits
#define STOPBITS_1	    0	// stopbits = 1 
#define STOPBITS_2 	 	1	// stopbits = 2

//parity bits
#define  PARITY_NONE	0	// no parity
#define  PARITY_ODD		1	// odd parity
#define  PARITY_EVEN	2	// even parity

//flow control
#define FLOW_TYPE_XOFF	0
#define FLOW_TYPE_CTS	1
#define FLOW_TYPE_ETX	2
#define FLOW_TYPE_DTR	3 

#define COM1DEVICE		"/dev/ttyS0"
#define COM2DEVICE		"/dev/ttyS1"

// function prototypes
	
class	CCom
{
	int		nDevice;
	int		nFd;
	struct termios oldtio;

	int		initialize();
	void 	initSettings();
public:
	CCom(int com);						// Constructor
	~CCom();								// Destructor

	int 	getchar(int flag);				// get character
	int		gets(char* buf, int length);	// get string
	int 	getStatus() { return nFd; };
	void 	putchar(char c);				// put character
	void 	puts(char* str);				// put string
};

#endif 
