/*	This file is part of Jenux.

    Jenux is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jenux is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jenux.  If not, see <http://www.gnu.org/licenses/>.

	Compiler		: gcc 4.8.5++
	Email			: matsuzawa.jei@nifty.com
	Maintenance		:
		May 25.'17	Released as GPL software officially
*/
#include	<iostream>
#include	<sys/ioctl.h>
#include	<unistd.h>
using namespace std;
#include	"../include/pifg/libPIF.h"
#include	"../include/pifg/CLog.h"
#include <sys/stat.h>

CLog	oLog;
CPif*	plib;

static void	resetScreen();
static int white, black, blue, red;
//int printdataOn;
//extern int flashGOPFlag; 

#define LAST_CHECKSUM  0x77b9   // version 1.0.4
//#define LAST_CHECKSUM  0x27f9     // version 1.0.3
//#define LAST_CHECKSUM  0x6e43     // version 1.0.2
//#define LAST_CHECKSUM  0x13fe   // version 1.0.1

int	main(int argc, char* argv[])
{
//	CPif*	plib;
    int checkSum;
	char tempString[200];
//    flashGOPFlag = 1;
	int retrunUpdateGOP = -1;
	int isFlash = 0;
   
//  create CPif class instance
    if((plib = new CPif()) == NULL){
		cout << "Faild to create CPif class instance!\n";
        return(false);
    }
    
    if(!(plib->pPanel->bModel)){
        black = GOP_BLACK;
        white = GOP_WHITE;
        blue  = GOP_BLUE;
        red   = GOP_RED;
    }
    else{
        black = ISD_BLACK;
        white = ISD_WHITE;
        blue  = BLUE;
        red   = RED;
    }
    
    checkSum = plib->p_getChecksum();
    cout << "calculated checksum is " << checkSum << endl;
	
	if (checkSum == 0x77b9)				// added @7.04-12 for the GOP TDU Screen version(JEI firmware version)
		strcpy (plib->pPanel->TDU_Graphic_Ver," = 1.0.4");
	else if (checkSum == 0x27f9)
		strcpy (plib->pPanel->TDU_Graphic_Ver," = 1.0.3");
	else if (checkSum == 0x6e43)
		strcpy (plib->pPanel->TDU_Graphic_Ver," = 1.0.2");
	else if (checkSum == 0x13fe)
		strcpy (plib->pPanel->TDU_Graphic_Ver," = 1.0.1");
	else
		strcpy (plib->pPanel->TDU_Graphic_Ver," = false");
	cout << "GOP Firmware Version" << plib->pPanel->TDU_Graphic_Ver << endl;
	sprintf(tempString,"echo TDU Screen Data Version %s > /home/Genesis/TDU_Screen_Version.txt",plib->pPanel->TDU_Graphic_Ver);
	system (tempString);
	
    resetScreen();
    
//    plib->p_clearScreen();
	plib->p_display(10,10,"BEGIN PANEL FLASH ROUTINE");
//	sleep(1);
	plib->p_display(10,30,"CALCULATING CHECKSUM VALUE");
	sleep(1);
    
    // flash if requested through TDU
	if(access("/home/Genesis/SLflashPanel",F_OK) == 0)
	{
		system("rm /home/Genesis/SLflashPanel");
		plib->p_display(10,50,"CHECKSUM VALID");
		plib->p_display(10,70,"PANEL FLASH REQUESTED");
        sleep(1);
		cout << "flashGOP" << "Start flashing!\n";
		system ("echo \"FlashRequested = 1\" > /home/Genesis/GOPFlashRequested.txt");
		plib->e_ledblnk(1);   //red LED blink ON
		retrunUpdateGOP = plib->p_updateGOP("/home/jenux/bin/index.txt");
		sleep(1);
		if (retrunUpdateGOP){
			plib->e_ledblnk(0);
			cout << "Complete successfully!\n";
			isFlash = 1;
			sleep(1);
		}
		else{
			plib->e_led(LED_ALARM, 1);
			resetScreen();
			plib->p_display(10,90,"PANEL FLASH NOT COMPLETED");
		}
		
	}
    // no flash needed or requested
	else if(checkSum == LAST_CHECKSUM )
	{
		// no need to update
		plib->p_display(10,50,"CHECKSUM IS VALID");
		sleep(1);
		plib->p_display(10,70,"PANEL FLASH NOT NEEDED");
		system ("echo \"FlashRequested = 0\" > /home/Genesis/GOPFlashRequested.txt");
		isFlash = 0;
		sleep(1);
	}
// flash needed
	else
	{
		plib->p_display(10,50,"CHECKSUM INVALID");
		plib->p_display(10,70,"PANEL FLASH NEEDED");
        sleep(1);
		cout << "flashGOP" << "Start flashing!\n";
		system ("echo \"FlashRequested = 1\" > /home/Genesis/GOPFlashRequested.txt");
		plib->e_ledblnk(1);   //red LED blink ON
		retrunUpdateGOP = plib->p_updateGOP("/home/jenux/bin/index.txt");
		sleep(1);
		if (retrunUpdateGOP){
			plib->e_ledblnk(0);
			cout << "Complete successfully!\n";
			isFlash = 1;
			sleep(1);
		}
		else{
			plib->e_led(LED_ALARM, 1);
			resetScreen();
			plib->p_display(10,90,"PANEL FLASH NOT COMPLETED");
		}
	}
	if (!isFlash)
	{
		plib->p_clearScreen_New();
		plib->p_dispPage(4);
		cout << "iFlash=0\n";
	}
//	 system("echo in flashGOP_Done before initialize .... $(date)>> MyoPanelFlash.txt");
//	plib->initialize();
	
	return 0;
}

static void	resetScreen()
{
	plib->p_clearScreen();
    //	plib->p_dispPage(4);
	plib->p_dispPage(5);
    plib->p_setColor(black,white);
//	plib->p_display(20,10,"<<< Panel Flash Check >>>");
}
