////////////////////////////////////////////////////////////////////////////////
//	Module			: CCom.C
//	Description		: Serial comunication handler
//	Compiler		: gcc version 3.2 (Red Hat Linux 8.0 3.2-7) 
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu@po.mcci.or.jp
//------------------------------------------------------------------------------
//	Maintenance:
//		Apr. 15,'03	EV1.0	1sr release 
//-----------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
#include	<iostream>
#include 	<fstream>
using namespace std;

#include 	<unistd.h>
#include 	<fcntl.h>
#include 	<time.h>
#include 	<cstring>
#include 	<sys/types.h>

#include	"CCom.h"

#define _POSIX_SOURCE 1

//	Global Methods ___________________________________________________________
/*
	Method 		: CCom()
	Description	: Constructor
	Procedure	: Initialize serial port 
	Arguments	: int com = 1 : com1
						    2 : com2
*/
CCom::CCom(int com)
{
//	cout <<	"Create CCom class object ...\n";
	nDevice = com;
	initialize();						// Initialize serial port
}

/*
	Method 		: ~CCom()
	Description	: Destructor
	Procedure	: 1. restore old por setting
				  2. close port 
*/
CCom::~CCom()
{
    tcsetattr(nFd, TCSANOW, &oldtio);	// restore old port setting
	close(nFd);							// close port
}

/*
	Method 		: getchar()
	Description	: RX a character
	Arguments	: int flag = 0 : wait until RX any data  
							 1 : immediate return if no data 
	Returns		: int RX character
*/
int CCom::getchar(int flag)
{
	int c = -1;

	while(1){
		if(read(nFd,&c,1)){
			c &= 0xff;
			break;
		}
		else if(flag) break;
		usleep(1);
	}
	return c;
}

/*
	Method 		: putchar()
	Description	: TX a character 
	Arguments	: char c = TX character
*/
void CCom::putchar(char c)
{
     write(nFd, &c, 1);
}

/*
	Method 		: puts()
	Description	: TX string terminated by NULL 
	Arguments	: char* str = pointer to string 
*/
void CCom::puts(char* str)
{
     write(nFd, str, strlen(str));
}

//	Private Methods __________________________________________________
/*
	Method 		: initialize()
	Description	: initialize com port 
	Rreturn		: int = fd : ok
					    -1 : error
*/
int CCom::initialize()
{
//	1. open the device(com port) 
	switch(nDevice){
	    case 1: nFd = open(COM1DEVICE, O_RDWR|O_NOCTTY); break;
	    case 2: nFd = open(COM2DEVICE, O_RDWR|O_NOCTTY); break;
	}
//	2. initialize port settings 
	if(nFd != -1){
		tcgetattr(nFd, &oldtio); 		// save old port settings
		initSettings();					// initialize port's settings
	}
	else
		cout << "Failed to open COM" << nDevice << endl;
	return nFd;
}

/*
	Method 		: initSettings()
	Description	: initialize com port settings 
*/
void CCom::initSettings()
{
	struct termios newtio;
  
	tcgetattr(nFd, &newtio);
	newtio.c_cflag |= B9600|CS8|CLOCAL|CREAD;
	newtio.c_iflag = IGNPAR;

	//disable software flow control
	newtio.c_iflag &= ~(IXON | IXOFF | IXANY);
	newtio.c_oflag = 0;

	// for canonical input processing (raw data)			
	newtio.c_lflag = 0;

	//enable read to return immediately even if no data is available
	newtio.c_cc[VMIN]=0;
	newtio.c_cc[VTIME]=0;
	tcsetattr(nFd, TCSANOW, &newtio);
}

