/*	This file is part of Jenux.

    Jenux is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jenux is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jenux.  If not, see <http://www.gnu.org/licenses/>.

	Module			: pifc2.h
	Description		: Header file for PIF2 (LP-042) 
	Compiler		: gcc 4.8.5++
	Email			: matsuzawa.jei@nifty.com
	Maintenance		:
		May 25.'17	Released as GPL software officially
*/
#define PIF_MAJOR		99			// Major Number 

#define	PCIREG_MAX		64

//	EEPROM Control bits in CNTRL register
#define		EESK	0x01000000			// Serial EEPROM Clock
#define		EECS	0x02000000			// Serial EEPROM Chip Select
#define		EEDO	0x04000000			// Serial EEPROM Write bit
#define		EEDI	0x08000000			// Serial EEPROM Read bit
#define		RELOAD	0x20000000			// Reload Configuration Register

//		PIF Registers	______________________________________________________
//
#define	PIF_CTRL		0		// PIF resource control register
//	bit0 to bit5 : Interrupt mask (0: Disable/ 1: Enable)
	#define	MERR		0x0001		// Error Int. Mask 
	#define	MWAR		0x0002		// Warning Int. Mask 
	#define	MEIF		0x0004		// EIF Inactive Int. Mask
	#define	MPWR		0x0008		// Page Write Request Int. Mask
	#define	MUIA		0x0010		// UART-A Int. Mask 
    #define MUIB		0x0020      // UART-B Int. Mask 
//	bit8 to bit15 : Misc. control bits 
	#define	URST		0x0100		// Reset UART 
	#define	IRST		0x0200		// Reset video circuit 
	#define	CSEL0		0x0400		// Select local clock 
	#define	CSEL1		0x0800		// 
	#define	SVDE		0x1000		// Select width of VDW# 
	#define	IBE			0x2000		// 1: byte swap 
	#define	IBS			0x4000		// 1: bit swap 
	#define	IREV		0x8000		// 1: reverse image

//	#define	CNTL_DEFAULT	(CSEL0|IBE|IBS|MUIB|MUIA|MPWR|MEIF|MWAR|MERR)
	#define	CNTL_DEFAULT	(IBE|IBS|MUIB|MUIA|MPWR|MEIF|MWAR|MERR)

#define	PIF_ISR			1		// PIF Interrupt/Status reg. offset
//	bit0 to bit5 : Interrupt flag 
	#define	FERR		0x0001		// Error Int. 
	#define	FWAR		0x0002		// Warning Int.  
	#define	FEIF		0x0004		// EIF Inactive Int.
	#define	FPWR		0x0008		// Page Write Request Int.
	#define	FUIA		0x0010		// UART-A Int.  
    #define FUIB		0x0020      // UART-B Int.  
//	bit8 to bit
	#define	PERR		0x0100		// PERR (active HIGH)
	#define	PWAR		0x0200		// PWAR (active HIGH) 
	#define	EACT		0x0400		// EACT (active HIGH)
	#define	CACT		0x0800		// CACT (active HIGH)
	
#define PIF_TEST	    2		// PIF test register
#define VIDEO_WIDTH     3		// Video width register
#define VIDEO_HEIGHT    4		// Video height register
#define VIDEO_AREA      5		// Video area register

#define	BANK_STATUS		1		// Video status register
	#define	ABKF		0x0001
	#define	ABKR		0x0002
	#define	ABKW		0x0004
	#define	ABKWEN		0x0008
	#define	BBKF		0x0010
	#define	BBKR		0x0020
	#define	BBKW		0x0040
	#define	BBKWEN		0x0080
	#define	IFE			0x0100
	#define	BANK_FULL	(ABKF|BBKF)
	#define	BANK_A_READY	(ABKW|ABKWEN)
	#define	BANK_B_READY	(BBKW|BBKWEN)

//	macros

#define	getPciReg(offset)		(readl(pPCIREG+offset))
#define	putPciReg(offset,val)	(writel(val, pPCIREG+offset))
#define	getPifReg(offset) 		(readl(pPIFREG+offset))
#define	putPifReg(offset,val)	(writel(val, pPIFREG+offset))
#define	getIFC() 				(readl(pBANK))
#define	getBankSt() 			(readl(pBANK+BANK_STATUS))

