///////////////////////////////////////////////////////////////////////////////
//	Module			: pci9054.h
//	Description		: Equations for PLX PCI9054 (PCI I/O Acceleratir)
//
//	Compiler		: gcc version 3.2.2 or higher 
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu.jei@nifty.com
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Maintenance:
//	<Date>		 <Version>	<Desc.>
//	Mar. 3, 2006  0.0.1		 1st release for evaluation 
///////////////////////////////////////////////////////////////////////////////	
#define PIF_VENDOR_ID		0x157A		// vender ID (JEI)
#define PIF_DEVICE_ID		0x9054		// device ID

// 	PCI9054 Registers	______________________________________________________
//		These registers are mapped in the PCIBAR0(PCI Base Address 0)
//
//		<Local Configuration Registers>
//
#define	LBRD0		(pPCIREG+0x18/4)	// Interrupt Control/Status Register
	#define		PTPWM	0x08000000			// PCI Target PCI Write Mode
//
//		<Runtime Registers>
//
#define	INTCSR		(pPCIREG+0x68/4)	// Interrupt Control/Status Register
	#define		LIIE		0x00000800		// Local Interruput Input Enable
#define CNTRL		(pPCIREG+0x6C/4)	// Control Register
//	#define		RELOAD	0x20000000			// Reload Configuration Register
	#define		RESET	0x40000000			// PCI Adapter Software Reset

//		<DMA Registers>
//
#define	DMAMODE0	(pPCIREG+0x80/4)   	// DMA Channel 0 Mode
	#define		DMA0_DIE	0x0400		// Done Interrupt Enable
	#define		DMA0_SGM	0x0200		// Scatter/Gather Mode
	#define		DMA0_MODE	DMA0_SGM	// default mode
#define	DMAPADR0	(pPCIREG+0x84/4)   	// DMA Channel 0 PCI Address
#define	DMALADR0	(pPCIREG+0x88/4)   	// DMA Channel 0 Local Address
#define	DMASIZ0		(pPCIREG+0x8C/4)   	// DMA Channel 0 Transfer Size
#define	DMADPR0		(pPCIREG+0x90/4)   	// DMA Channel 0 Descriptor Pointer
	#define		DMA0_DL		0x01			// Descriptor Location
	#define		DMA0_EOC	0x02			// End of chain
#define	DMACSR0		(pPCIREG+0xA8/4)   	// DMA Channel 0 Command/Status 
	#define		DMA0_EN		0x01			// Channel 0 Enable
	#define		DMA0_ST		0x02			// Channel 0 Start
	#define		DMA0_ABORT	0x04			// Channel 0 Abort
	#define		DMA0_CLI	0x08			// Channel 0 Clear Interrupt
	#define		DMA0_DONE	0x10			// Channel 0 Done

#define	DMA_LOCADR	0x08000000
