/***************************************************************************
serial.h
***************************************************************************/
#ifndef SERIAL_INCLUDED
#define SERIAL_INCLUDED       

//baud rate constants
//0      300
//1      1200
//2      2400
//3      4800
//4      9600
//5      19200
//6      38400
//7      57600
//8      115200
#define BAUD_3    0        //BAUD RATE 300
#define BAUD_12   1        //BAUD RATE 1200
#define BAUD_24   2        //BAUD RATE 2400
#define BAUD_48   3        //BAUD RATE 4800
#define BAUD_96   4        //BAUD RATE 9600
#define BAUD_192  5        //BAUD RATE 19200
#define BAUD_384  6        //BAUD RATE 38400
#define BAUD_576  7        //BAUD RATE 57600
#define BAUD_1152 8        //BAUD RATE 115200


//databits
#define BITS_7     0   //word length 7
#define BITS_8     1   //word length 8

//stopbits
#define  STOPBITS_0	       0  /* stopbits = 1*/
#define  STOPBITS_CSTOPB 	 1  /* stopbits = 2 */

//parity bits
#define  PARITY_NONE	   0
#define  PARITY_ODD		   1
#define  PARITY_EVEN     2

//flow control
#define FLOW_TYPE_XOFF 0
#define FLOW_TYPE_CTS  1
#define FLOW_TYPE_ETX  2
#define FLOW_TYPE_DTR  3
#define FLOW_TYPE_POR_XOFF 4

// function prototypes
	
int serial_init(int comdevice);
unsigned char serial_peekc(int comdevice);
unsigned char serial_getchar(int comdevice);
unsigned long serial_ungetchar(int comdevice, unsigned char c);
int serial_getlength(int comdevice);
int serial_close(int comdevice);
void serial_setbaudrate(int comdevice, int nBaudRate);
void serial_setwordlength(int comdevice, unsigned char c);
void serial_setstopbits(int comdevice, unsigned char c);
void serial_setparity(int comdevice, unsigned char c);
void serial_setflowctrl(int comdevice, unsigned char c);

#endif //SERIAL_INCLUDED
