/*	This file is part of Jenux.

    Jenux is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jenux is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jenux.  If not, see <http://www.gnu.org/licenses/>.

	Module			: pif_ioctl.h
	Description		: Header file for ioctl commands
	Compiler		: gcc 4.8.5++
	Email			: matsuzawa.jei@nifty.com
	Maintenance		:
		May 25.'17	Released as GPL software officially
*/
#include	<linux/ioctl.h>

//	Magic number
#define	PIF_MAGIC	0xE0

#define	PIF_RD_TYPE		_IOR(PIF_MAGIC,1,int)		// get PIFC type
#define	PIF_RD_VER		_IOR(PIF_MAGIC,2,int)		// get version
#define	PIF_RST_PIF		_IO(PIF_MAGIC,3)			// reset whole PIF-II
#define	PIF_RST_UART	_IO(PIF_MAGIC,4)			// reset UART	
#define	PIF_RST_VIDEO	_IO(PIF_MAGIC,5)			// reset video circuit
#define	PIF_RD_IRQ		_IOR(PIF_MAGIC,6,int)		// get IRQ
#define	PIF_RD_INTC		_IOR(PIF_MAGIC,7,int)		// get interrupt count
#define	PIF_RD_PERR		_IOR(PIF_MAGIC,8,int)		// get PERR intr. flag
#define	PIF_RST_PERR	_IO(PIF_MAGIC,9)			// reset PERR intr. flag
#define	PIF_RD_PWAR		_IOR(PIF_MAGIC,10,int)		// get PWAR intr. flag
#define	PIF_RST_PWAR	_IO(PIF_MAGIC,11)			// reset PWAR intr. flag
#define	PIF_RD_VDRQ		_IO(PIF_MAGIC,12)			// get VDRQ intr. flag
#define	PIF_WT_VIDEO	_IOW(PIF_MAGIC,13,int)		// start DMA transfer 
#define	PIF_RD_OPRXC	_IOR(PIF_MAGIC,14,int)		// get RX count from operation panel
#define	PIF_WT_TRIGGER	_IOW(PIF_MAGIC,15,int)		// set trigger level
#define	PIF_WT_BAUD		_IOW(PIF_MAGIC,16,int)		// set baud rate
#define	PIF_WT_CHANNEL	_IOW(PIF_MAGIC,17,int)		// select channel 
#define	PIF_RD_EIFRXC	_IOR(PIF_MAGIC,18,int)		// get RX count from EIF
#define	PIF_RD_PAGEND	_IOR(PIF_MAGIC,19,int)		// get PAGEND status
#define	PIF_RST_PAGEND	_IO(PIF_MAGIC,20)			// reset PAGEND status
#define	PIF_RD_REG		_IOR(PIF_MAGIC,21,int)		// read registers
#define	PIF_WT_REG		_IOW(PIF_MAGIC,22,int)		// write registers

typedef	struct {
	int	offset;			// register offset
	int	val;			// value (necessary for PIF_WT_REG command)
}REG;

