///////////////////////////////////////////////////////////////////////////////
//	Module			: CSformat.C 
//	Description		: Inplementation of CSformat class. This class handles
//					  Motrola S-format file. 
//
//	Compiler		: gcc version 3.2 (Red Hat Linux 8.0 3.2-7) 
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu@po.mcci.or.jp
//-----------------------------------------------------------------------------
//	Maintenance:
//		Apr. 14,'03	EV2.0	1st release
//-----------------------------------------------------------------------------
///////////////////////////////////////////////////////////////////////////////
#include	<iostream>
#include 	<fstream>
using namespace std;

//#include	<cstdlib>
//#include	<cstring>

#include	"fwupdator.h"
#include	"CSformat.h"

/*
	Method 		: Constructor
	Description	:  
	Arguments	: char* fname = pointer to file name for S-format file
*/
CSformat::CSformat(char* fname)
{
cout << "Open " << fname << " ....\n";
	fin.open(fname);						// Open S-format file 
	if(fin == NULL)
		nStatus = ERR_FILEOPEN2;
	else { 
		tmp.open(tmpfile,ios::out);			// Open tempory file (out) 
		if(tmp == NULL)
			nStatus = ERR_FILEOPEN3;
		else{
			extractData();					// Extract binary data
			tmp.close();
		}
	}
	if(!nStatus){
cout << "Write binary data into temporary file ....\n";
		tmp.open(tmpfile,ios::in);			// Open tempory file (in) 
		if(tmp == NULL)
			nStatus = ERR_FILEOPEN3;
	}
}

/*
	Method 		: Destructor
	Description	: Remove temporary file. 
*/
CSformat::~CSformat(){
	char	cmdbuf[32];

	tmp.close();
	strcpy(cmdbuf,"rm ");
	strcat(cmdbuf,tmpfile);
//	system(cmdbuf); 
	cout << cmdbuf << endl;
}

//	Public Methods ___________________________________________________________
/*
	Method 		: getchar()
	Description	: get character from temorary file 
	Arguments	: Nothing
	Returns		: char c = binary data in the temporary file
*/
char CSformat::getchar()
{
	char	c;

	tmp.get(c);
	return c;
}

/*
	Method 		: gets()
	Description	: get string from temorary file 
	Arguments	: char* buf = pointer to buffer 
				  int n = max. length
	Returns		: int n = actual length  
*/
int CSformat::gets(char* buf, int n)
{
	tmp.read(buf,n);
	return tmp.gcount();
}

//	Private Methods _________________________________________________________
/*
	Method 		: extractData()
	Description	: Extract S1 and S2 records from S-Format file, 
				  and then conbert them binary data.
	Arguments	: Nothing
	Returns		: Nothing
*/
void CSformat::extractData()		
{
	int		i,j,cnt;
	char	buf[64],*ptr;

	nS1start = nS2start = -1;
	nSize = 0;								// rest data size
	while(!fin.eof()){
		fin.getline(buf,63);				// get 1 line data	
		ptr = &buf[1];

// pick up S1 and S2 record
		switch(*ptr++){
			case '1': cnt = 2;break; 		// 2 byte address
			case '2': cnt = 3;break; 		// 3 byte address
			default: cnt = 0; break;
		}

//	convert data to binary
		if(cnt){		
			i = getByte(ptr) - cnt - 1; 
			nSize += i;

			ptr += 2;
//	get load address if necessary
			if((cnt == 2) && nS1start == -1){
				nS1start = getLaddr(ptr,cnt);	
				cout << "\tLoad address : " << hex << nS1start << endl;
			}
			else if((cnt == 3) && nS2start == -1){
				nS2start = getLaddr(ptr,cnt);	
				cout << "\tFound S2 records@" << nS2start << endl;

//		fill space betweed S1 and S2 records with 0xFF 
				j = nS2start - (nS1start + nSize);
				nSize += j;
				if(j > 0){
					cout << "\tFill " << j << " bytes with 0xFF..." << flush;
					while(j--)
						tmp.put(0xFF);
					cout << dec << endl;
				}
			}

//	write binary data into temporary file
			ptr += cnt * 2; 
			while(i--){
				tmp.put(getByte(ptr)); 
				ptr += 2;
			}
		}
	}
}

/*
	Method 		: getByte()
	Description	: get byte form HEX-ASCII string  
	Arguments	: int cnt 
	Returns		: int load address 
*/
int CSformat::getByte(char* ptr)
{
	return((hex2bin(*ptr) << 4) + hex2bin(*(ptr+1)));
}

/*
	Method 		: getLaddr()
	Description	: get load address
	Arguments	: int cnt 
	Returns		: int load address 
*/
int CSformat::getLaddr(char* ptr, int cnt)
{
	int	i,j;
	int addr = 0;

	for(i = 0; i < cnt; i++){
		j = getByte(ptr);
		addr = (addr << 8) + j;
		ptr += 2;
	}
	return addr;
}

/*
	Method 		: hex2bin()
	Description	: Convert HEX-ASCII to Binary
	Arguments	: int n = HEX-ASCII code 
	Returns		: int binary code 
*/
int CSformat::hex2bin(int n)
{
	n -= '0';
	if(n > 9) n -= 7;
	return(n);
}

